// Generated by CoffeeScript 1.7.1
(function() {
  var AREAS, DAMAGE_MAX, Employee, Location, Report, Sequelize, arg, async, sequelize, start;

  Sequelize = require('./index');

  async = require('async');

  AREAS = ['area1', 'area2', 'area3'];

  DAMAGE_MAX = 3;

  sequelize = new Sequelize('sequelize_test', 'sequelize_test', '', {
    dialect: 'postgres',
    host: '172.17.0.2',
    logging: false
  });

  Report = sequelize.define('Report', {
    area: {
      type: Sequelize.STRING,
      allowNull: false,
      validate: {
        isIn: [AREAS]
      }
    },
    damageLevel: {
      type: Sequelize.INTEGER,
      allowNull: false,
      defaultValue: 0,
      validate: {
        isInt: {
          msg: "Must be an integer"
        },
        min: 0,
        max: DAMAGE_MAX
      }
    },
    description: {
      type: Sequelize.TEXT,
      allowNull: true,
      validate: {
        notEmpty: true
      }
    }
  });

  Location = sequelize.define('Location', {
    latitude: {
      type: Sequelize.FLOAT(53),
      allowNull: false,
      validate: {
        isFloat: {
          msg: "Must be a floating point number"
        },
        min: -90.0,
        max: 90.0
      }
    },
    longitude: {
      type: Sequelize.FLOAT(53),
      allowNull: false,
      validate: {
        isFloat: {
          msg: "Must be a floating point number"
        },
        min: -180.0,
        max: 180.0
      }
    },
    altitude: {
      type: Sequelize.FLOAT(53),
      allowNull: true,
      defaultValue: null
    }
  });

  Employee = sequelize.define('Employee', {
    name: {
      type: Sequelize.STRING,
      allowNull: false
    }
  });

  Location.hasMany(Report);

  Report.belongsTo(Location);

  Employee.hasMany(Report);

  Report.hasMany(Employee);

  process.argv.shift();

  process.argv.shift();

  arg = process.argv[0];

  if (arg === 'seed') {
    sequelize.sync({
      force: true
    }).success(function() {
      console.log("synced database");

      Employee.bulkCreate([
        {name: 'A'},
        {name: 'B'},
        {name: 'C'}
      ]).then(function () {
        Employee.findAll().then(function (employees) {
          return async.timesSeries(2000, function(n, done) {
            var location;
            location = null;
            return async.series([
              function(done) {
                return Location.create({
                  latitude: Math.random() * 180 - 90,
                  longitude: Math.random() * 360 - 180
                }).success(function(obj) {
                  location = obj;
                  return done();
                }).error(function(error) {
                  return console.error(error);
                });
              }, function(done) {
                return async.times(2, function(n, done) {
                  return Report.create({
                    area: AREAS[n],
                    damageLevel: String(Math.floor(Math.random() * DAMAGE_MAX)),
                    description: Math.random() < 0.1 ? "this is a description " + (Math.random()) : null
                  }).success(function(report) {
                    return report.setLocation(location).done(function (err) {
                      if (err) return done(err);
                      report.setEmployees(employees).done(done);
                    });
                  }).error(function(error) {
                    return console.error(error);
                  });
                }, done);
              }
            ], function() {
              console.log(n);
              return done();
            });
          }, function(error) {
            if (error != null) {
              throw error;
            }
            return console.log("done");
          });
        });
      });
    }).error(function(error) {
      throw error;
    });
  } else if (arg === 'run') {
    console.log("start");
    start = new Date();

    /*
    Report.findAll
        include: [
            Location
        ]
    .done (err, damageReports) ->
        console.log "finish, took #{new Date() - start}"
    
    .on 'sql', (sql) ->
        console.log sql
     */
    Location.findAll({
      include: [
        {model: Report, include: [Employee]}
      ]
    }).done(function(err, locations) {
      if (err) return console.error(err.toString());
      return console.log("finish, took " + (new Date() - start));
    }).on('sql', function(sql) {
      return console.log(sql);
    });
  } else {
    console.log("expected to be run with 'seed' or 'run' argument");
  }

}).call(this);
